#!/usr/bin/perl
# -d:SmallProf
#use Perl6::Slurp;
#use XML::Simple;
#use CGI;
#use CGI::Lite;
#use Date::Manip;
#Date_Init("TZ=JST","ConvTZ=JST");
#use SVG;
#use KCatch;
use CGI::Carp qw( fatalsToBrowser );
use DBI;
use Date::Simple;
use DateTime;
use CGI::Minimal;
use MIME::Base64;
use Config::Simple;
use Data::Dumper;
#use utf8;
%DB::packages = ( 'main' => 1 ); 
my $tz = DateTime::TimeZone->new( name => 'local' );

my $cfg = new Config::Simple;
$cfg->read( 'config.ini' );
my $sql = $cfg->param( 'db.db' );
#$sql = 'SQLite';
#$sql = 'MySQL';

if ( $sql eq 'SQLite' ) {
	$dbh = DBI->connect("dbi:SQLite:dbname=ch.db", undef, undef, {
		AutoCommit => 1,
		RaiseError => 1,
	});
	$SQL{'SUBSTR'} = 'SUBSTR(start, 0, 9)';
}

if ( $sql eq 'MySQL' ) {
	my $name = $cfg->param( 'db.mysql_dbname' );
	my $host = $cfg->param( 'db.mysql_host' );
	my $port = $cfg->param( 'db.mysql_port' );
	my $user = $cfg->param( 'db.mysql_user' );
	my $pass = $cfg->param( 'db.mysql_passwd' );
	$dbh = DBI->connect("dbi:mysql:$name:$host:$port", $user, $pass, {
		AutoCommit => 1,
		RaiseError => 1,
	});
	$dbh->do( 'SET NAMES utf8' );
	$SQL{'SUBSTR'} = 'SUBSTRING(start, 1, 8)';
}

my $HTML;

#print "Content-Type: text/html\n\n";

$HTTP_HEADER = "Content-Type: text/html\n\n";
$HTML .= <<EOM;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<title>Rec10%HTML_TITLE_OPT%</title>
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rev="MADE" href="Rea10"> 
%REFRESH%
%SCRIPT%
</head>
<body>
%HTML_HEADER%
EOM


$q = new CGI::Minimal;
$mode = $q->param( 'mode' );

$display = $q->param( 'ch' );
$start   = $q->param( 'start' );
$stop    = $q->param( 'stop' );
$key     = $q->param( 'key' );
@id      = $q->param( 'id' );

%type = (
	'res'         => '一回限定',
	'rec'         => '最終段階',
	'key'         => '当日検索',
	'keyevery'    => '隔日検索',
	'tsrecording' => '録画途中',
	'tsfin'       => '録画終了',
	'tsmiss'      => '録画失敗',
	'b252ts'      => '解読予約',
	'tsdecoding'  => '解読途中',
	'ts2avi'      => '縁故予約',
	'local'       => '縁故於鯖',
	'grid'        => '縁故於網',
	'fin_local'   => '縁故完了',
	'end'         => '録画終了',
);

if ( $mode eq 'schedule' ) {

	$HTML =~ s/%HTML_TITLE_OPT%/ - Schedule Viewer/;
	my $order = $q->param( 'order' );
	my $extra = $q->param( 'extra' );
	if ( $order eq 'btime' ) {
		$order = 'btime';
	}
	else {
		$order = 'id';
	}

	my $ary_ref = $dbh->selectall_arrayref(
		"SELECT id, type, rectime.chtxt, chdata.ontv, ch.display, title, btime, etime, opt, deltaday, deltatime 
		FROM rectime 
		INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
		INNER JOIN ch     ON chdata.ontv   = ch.channel 
		ORDER BY $order");

	$HTML .= qq {<a href="rectool.pl">トップ</a>\n<br>\n};
	$HTML .= qq {<a href="rectool.pl?mode=graph">SVGによる予約状況画面</a>\n<br>\n};
	$HTML .= qq {<div style="font-size: 10pt; float:left;">\n};
	$HTML .= qq {<form method="get" action="rectool.pl">\n};
	$HTML .= qq {<input type="hidden" name="mode" value="change">\n};
	$HTML .= qq {<table summary="rectimetable" border=1 cellspacing=0>\n<tr>\n};
	$HTML .= qq {<th><br></th>\n};
	$HTML .= qq {<th><a href="rectool.pl?mode=schedule">ID</a></th>\n};
	$HTML .= qq {<th>タイプ</th>\n};
	$HTML .= qq {<th>チャンネル</th>\n};
	$HTML .= qq {<th>タイトル</th>\n};
	$HTML .= qq {<th><a href="rectool.pl?mode=schedule&amp;order=btime">開始時刻</a></th>\n};
	$HTML .= qq {<th>終了時刻</th>\n};
	$HTML .= qq {<th>録画時間</th>\n};
	$HTML .= qq {<th>オプション</th>\n};
	$HTML .= qq {<th>dd</th>\n};
	$HTML .= qq {<th>dt</th>\n};
	$HTML .= qq {<th>extra</th>\n} if ( $extra );
	$HTML .= qq {</tr>\n};
	foreach my $line ( @{ $ary_ref } ) {

		$type = $type{$line->[1]} || $line->[1];
		if    ( $line->[1] =~ /key/ ) {
			$type = qq {<span style="color: #800080">$type</span>};
			$line->[9]  = qq {<span style="color: #FF0000">空</span>} if ( !$line->[9] && $line->[1] eq 'keyevery' );
			$line->[10] = qq {<span style="color: #FF0000">空</span>} if ( !$line->[10] );
			$line->[11] = qq {<span style="color: #FF0000">空</span>} if ( !$line->[11] );
		}
		elsif ( $line->[1] =~ /^re/ ) {
			$type = qq {<span style="color: #A0A000">$type</span>};
		}
		elsif ( $line->[1] eq 'tsrecording' ) {
			$type = qq {<span style="color: #FFA000">$type</span>};
		}
		elsif ( $line->[1] eq 'ts2avi' ) {
			$type = qq {<span style="color: #404040">$type</span>};
		}
		else {
			$type = qq {<span style="color: #A0A0A0">$type</span>};
		}
		$display = $q->url_encode( $line->[4] );
		my @unix_6 = $line->[6] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2}):(.{2})/;
		my $unix_6 = DateTime->new(
			year => $unix_6[0], month  => $unix_6[1], day    => $unix_6[2],
			hour => $unix_6[3], minute => $unix_6[4], second => $unix_6[5], 
			time_zone => $tz
		);
		my @unix_7 = $line->[7] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2}):(.{2})/;
		my $unix_7 = DateTime->new(
			year => $unix_7[0], month  => $unix_7[1], day    => $unix_7[2],
			hour => $unix_7[3], minute => $unix_7[4], second => $unix_7[5], 
			time_zone => $tz
		);

		my $btime = $unix_6->strftime( '%Y%m%d%H%M%S' );
		my $etime = $unix_7->strftime( '%Y%m%d%H%M%S' );
#		if ( 0 and $line->[1] eq 'keyevery' ) {
		if ( $extra and $line->[1] =~ /key|res/ ) {
			my @ary = $dbh->selectrow_array(
				"SELECT title, exp FROM tv 
				WHERE channel = '$line->[3]' 
				AND start = '$btime' 
				AND stop  = '$etime' ");
			$ary[0] = '説明' if ( $line->[1] eq 'res' );
			if ( $ary[0] ) {
				$ary[0] =~ s/無料≫//;
				$ary[0] =~ s/\Q$line->[5]\E// if ( $ary[0] ne $line->[5] );
				if ( $ary[1] ) {
					$line->[11] = qq {<span style="border: thin outset; cursor: help" title="$ary[1]">$ary[0]</span>};
				}
				else {
					$line->[11] = qq {$ary[0]なし};
				}
			}
			else {
				$line->[11] = qq {<span style="color: #FF0000">空</span>};
			}
		}

		my $diffmin = int ( ( $unix_7->epoch - $unix_6->epoch ) / 60 );
#		my $diffmin = ( $unix_7 - $unix_6 )->delta_minutes;
		my $begin   = $unix_6->strftime( '%m/%d %H:%M' );
		if ( $unix_6->month == $unix_7->month && $unix_6->day == $unix_7->day )
		{
			$end   = $unix_7->strftime( '%H:%M' );
		}
		else {
			$end   = $unix_7->strftime( '翌 %H:%M' );
		}
		my $hour = int( $diffmin / 60 );
		my $min  = $diffmin - $hour * 60;
		my $diff = '';
		$diff .= $hour . '時間' if ( $hour );
		$diff .= $min  . '分'   if ( $min );

		$HTML .= qq {<tr align="center">\n};
		$HTML .= qq {<td><input type="checkbox" name="id" value="$line->[0]"></td>\n};
		$HTML .= qq {<td>$line->[0]</td>\n};
		$HTML .= qq {<td>$type</td>\n};
		$HTML .= qq {<td><a href="rectool.pl?mode=program&amp;ch=$display">$line->[2]</a></td>\n};
		$HTML .= qq {<td><a href="rectool.pl?mode=change&amp;edit=edit&amp;id=$line->[0]">$line->[5]</a></td>\n};
		$HTML .= qq {<td>$begin</td>\n<td>$end</td>\n};
		if ( 
			$line->[1] =~ /recording/ 
				&&
			$unix_6->epoch <= time && time <= $unix_7->epoch
		)
		{
			$percent = int( ( 100 * ( time - $unix_6->epoch ) ) / ( $diffmin * 60 ) );
			$HTML .= qq {<td><hr style="margin: 0 auto 0 0; height: 4px; width: $percent%; background-color: blue; border: none;">$diff</td>\n};
		}
		else {
			$HTML .= qq {<td>$diff</td>\n};
		}
		$HTML .= qq {<td>$line->[8]</td>\n<td>$line->[9]</td>\n<td>$line->[10]</td>\n};
		$HTML .= qq {<td>$line->[11]</td>\n} if ( $extra );
		$HTML .= qq {</tr>\n};
	}
	$HTML .= qq {</table>\n};
	$HTML .= qq {<input type="submit" name="edit" value="編集(要JS)">\n};
	$HTML .= qq {<input type="submit" name="edit" value="編集(非JS)">\n};
	$HTML .= qq {<input type="submit" name="delete" value="削除">\n</form>\n};
	goto end;
}

if ( $mode eq 'graph' ) {

	$graph = $q->param( 'graph' );

	if ( $graph )
	{
		print "Content-Type: image/svg+xml\n\n";

		require SVG;
		$graph = Date::Simple->new( split /-/, $graph );
		$graph_bgn = $graph->format('%Y-%m-%d');
		$graph_end = $graph->next->format('%Y-%m-%d');
		$day = $graph->day;
		$today = $graph eq Date::Simple->today() ? 1 : 0;
		
		$tuner{terrestrial} = 2; #$cfg->param( 'env.te_max' );
		$tuner{satellite}   = 4; #$cfg->param( 'env.bscs_max' );
		$tuner{all} = $tuner{terrestrial} + $tuner{satellite};
		$hours = 24;
		$width = 30 * $hours;

		$svg = new SVG( width => 820, height => $tuner{all} * 20 + 40 );
		$svg->rectangle( 'x' => 40, 'y' => 20, 
			width => $width + 20, height => $tuner{all} * 20 + 10, 
			rx => 15, ry => 15, 
			style => { stroke => 'blue', fill => 'white' } );
		for ( 1..$tuner{terrestrial} ) {
			$svg->text( 'x' => 10, 'y' => ( $_ + 1 ) * 20 )
				->cdata( "T$_" );
		}
		for ( 1..$tuner{satellite} ) {
			$svg->text( 'x' => 10, 'y' => ( $_ + $tuner{terrestrial} + 1 ) * 20 )
				->cdata( "S$_" );
		}
		for ( 0..$hours ) {
			$svg->text( 'x' => $_ * 30 + 60, 'y' => 15 )
				->cdata( sprintf( '%02d', $_ ) ) if ( $_ < $hours );
#			$svg->line( ); # for require
			$svg->tag( 'line', x1 => $_ * 30 + 50, x2 => $_ * 30 + 50, y1 => 30, y2 => $tuner{all} * 20 + 20, 
				style => { stroke => 'gray' } );
		}
		for ( 1..$tuner{all} ) {
			$svg->rectangle( 'x' => 50, 'y' => $_ * 20 + 10, width => $width, height => 10 );
		}
		if ( $today ) {
			require Time::Simple;
			my $time = Time::Simple->new();
			my $x = ( $time->hours * 60 + $time->minutes ) * 0.5;
			$svg->tag( 'line', x1 => $x, x2 => $x, y1 => 30, y2 => $tuner{all} * 20 + 20, 
				style => { stroke => 'red', 'fill-opacity' => '1.0' } );
		}
		foreach my $bctype ( 'te%', '_s%' ) {
			my $tuner = $bctype eq 'te%' ? $tuner{terrestrial} : $tuner{satellite};
			my $ary_ref = $dbh->selectall_arrayref(
				"SELECT id, type, rectime.chtxt, title, btime, etime, opt FROM rectime 
				INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
				WHERE chdata.bctype LIKE '$bctype' 
				AND type IN ( 'rec', 'res', 'key', 'keyevery' ) 
				AND 
				(
					'$graph_bgn 00:00' <= btime AND btime <  '$graph_end 00:00'
						OR
					'$graph_bgn 00:00' <  etime AND etime <= '$graph_end 00:00'
				)
				ORDER BY id"
			);
			foreach my $line ( @{ $ary_ref } ) {
				@start = $line->[4] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2})/;
				@stop  = $line->[5] =~ /(.{4})-(.{2})-(.{2}) (.{2}):(.{2})/;
				$start = ( ( $day == $start[2] ? 0 : 24 * 60 ) + $start[3] * 60 + $start[4] ) * 0.5;
				$stop  = ( ( $day == $stop [2] ? 0 : 24 * 60 ) + $stop [3] * 60 + $stop [4] ) * 0.5;
				$start = 0      if ( $start < 0 || $day > $start[2] ); # 月の変わり目はスルー
				$stop  = $width if ( $stop  > $width );
				$begin = $line->[4];
				$end   = $line->[5];

				my $ary = $dbh->selectall_arrayref( 
					"SELECT id, type, rectime.chtxt, title, btime, etime, opt FROM rectime 
					INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
					WHERE chdata.bctype LIKE '$bctype' AND 
					( 
						NOT 
						( 
							( etime <= '$begin' ) 
								OR 
							( btime >= '$end'   ) 
						 ) 
					) 
					ORDER BY id" 
				);
				my @ary = @{$ary};
				for ( 0..$tuner - 1 ) {
					$f = 1;
					$i = $_;
					for ( 0..4 ) {
						$f = 0 if ( $line->[$_] ne $ary[$i]->[$_] );
					}
					if ( $f ) {
						$slot = $i;
					}
				}
				my ( $r, $g, $b ) = ( 0, 0, 0 );
				$r += 255 if ( $line->[6] =~ /a/ );
				$g += 255 if ( $line->[6] =~ /H/ );
				$b += 255 if ( $line->[6] =~ /2/ );
				if ( $r + $g + $b == 255 * 3 ){
					$r = 0;
					$g = 255;
					$b = 255;
				}
				if ( $r + $g + $b == 0 ){
					$r = $g = $b = 128;
				}
				my %escaped = ( '&' => 'amp', '<' => 'lt', '>' => 'gt', '"' => 'quot' );
				sub html_escape{
				    my $str = shift or return;
				    my $result = '';
				    $result .= $escaped{$_} ? '&' . $escaped{$_} . ';' : $_
					for (split //, $str);
				    $result;
				}
				$svg->anchor(
					-href  => "rectool.pl?mode=change&amp;edit=edit&amp;id=$line->[0]",
					target => '_blank',
					-title  => html_escape( $line->[3] ),
				)->rectangle( 
					'x' => 50 + $start, 
					'y' => 30 + ( $bctype eq 'te%' ? 0 : $tuner{terrestrial} * 20 ) + $slot * 20, 
					width => $stop - $start, 
					height => 10, 
					style => { fill => "rgb($r,$g,$b)" } );
			}
		}
		print $svg->xmlify;
		exit;
	}
	else
	{
		$HTML =~ s/%HTML_TITLE_OPT%/ - Schedule Viewer - Graphical/;
		$HTML .= qq {<div style="float:left;">\n};
#		$base64 = encode_base64( $svg->xmlify );
#		$HTML .= qq {<object data="data:image/svg+xml;base64,$base64">\n</object>\n};
		$HTML .= qq {予約状況一覧です。T1,T2は地上波、S1,S2はBS/CS、赤はアニメ、緑はHD、青は2 passを示しています。<br>\n};
		$HTML .= qq {SVGが利用可能なブラウザでご覧ください。<br>\n};

		$ary_ref = $dbh->selectcol_arrayref(
#			"SELECT DISTINCT SUBSTR( btime, 0, 11 ) 
			"SELECT DISTINCT DATE( btime ) 
			FROM rectime 
			WHERE type in ( 'rec', 'res', 'key', 'keyevery' ) 
			ORDER BY btime"
		);
		foreach my $date ( @{ $ary_ref } ) {
			my @date = $date =~ /(.{4})-(.{2})-(.{2})/;
			my $dn = DateTime->new( year => $date[0], month => $date[1], day => $date[2], locale => 'ja_JP' )->day_name;
			utf8::encode( $dn );
			$HTML .= qq {$date[1]/$date[2]($dn)の予約状況<br>\n};
			$HTML .= qq {<object type="image/svg+xml" data="rectool.pl?mode=graph&amp;graph=$date">\n};
			# width=821 height=121>\n};
			$HTML .= qq {SVG Image $date\n</object>\n<br>\n};

			$date2 = Date::Simple->new( @date )->next->format('%Y-%m-%d');
			my $ary_ref = $dbh->selectall_arrayref(
				"SELECT chtxt, title, btime, etime FROM rectime 
				WHERE '$date 00:00' <= btime AND etime <= '$date2 01:00'
				ORDER BY btime"
			);

			foreach my $line ( @{ $ary_ref } ) {
#				$HTML .= qq {$line->[0] $line->[1] $line->[2] $line->[3]<br>\n};
			}

		}

		goto end;
	}
}

if ( $mode eq 'change' ) {
	$HTML =~ s/%HTML_TITLE_OPT%/ - Schedule Editor/;
	$HTML .= qq {<div style="float:left;">\n};

	if ( $q->param( 'delete' ) )
	{
		if ( @id ) {
			foreach my $id ( @id ) {
				$dbh->do( "DELETE FROM rectime WHERE id = '$id'" );
			}
			$HTML .= qq {<a href="rectool.pl">トップ</a>\n<br>\n};
			$HTML .= qq {<a href="rectool.pl?mode=schedule">予約確認画面</a><br>\n};
			$HTML .= "削除しました。<br>\n5秒後に予約確認画面に移動します。<br>\n";
			$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="5; url=rectool.pl?mode=schedule">|;
			goto end;
		}
	}
	if ( $q->param( 'edit' ) )
	{
		if ( $q->param( 'edit' ) eq '編集(要JS)' ) {
			$HTML .= qq {<a href="rectool.pl">トップ</a>\n<br>\n};
			$HTML .= "スケジュール編集画面に移動します。<br>\n";
			$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="0; url=../rec10web/rec10web.py?exec=edit:$id[0]">|;
			goto end;
		}
		else {
			$script = <<EOM;
				<script type="text/javascript" src="http://www.enjoyxstudy.com/javascript/dateformat/dateformat.js">
				</script>
				<script type="text/javascript">
				function setType(value){
					var index = document.reserve.type.selectedIndex;
					if ( index == 0 ) {
						document.reserve.deltaday.value  = 7;
						document.reserve.deltatime.value = 3;
					}
					if ( index == 1 ){
						var date       = new Date();
						var dateFormat = new DateFormat("yyyy-MM-dd HH:mm:ss");
						date.setMinutes(0, 0, 0);
						date.setSeconds( date.getSeconds() + 3600 );
						document.reserve.begin.value = dateFormat.format(date);
						date.setSeconds( date.getSeconds() + 3600 );
						document.reserve.end.value   = dateFormat.format(date);
					}
				}
				</script>
EOM
			$script =~ s/\t{4}//gs;
			$HTML =~ s/%SCRIPT%/$script/;

			$HTML .= "スケジュール編集画面です。<br>\n";
			$HTML .= "実装がとても適当なので、利用には細心の注意を払ってください。<br>\n";
			if ( $id[0] ) {
				@reserve = $dbh->selectrow_array(
					"SELECT id, type, chtxt, title, btime, etime, deltaday, deltatime, opt 
					FROM rectime 
					WHERE id = $id[0]"
				);
			}
			else {
				$reserve[1] = 'key';
			}
			my $len = length $reserve[0];
			$HTML .= qq {<form method="get" action="rectool.pl" name="reserve">\n};
			$HTML .= qq {<input type="hidden" name="mode" value="change">\n};
			$HTML .= qq {ID\n<input type="text" name="id" value="$reserve[0]" size=$len disabled>\n};
			$HTML .= qq {<input type="hidden" name="id" value="$reserve[0]">\n};
			$HTML .= qq {タイプ\n<select name="type" onChange="setType();">\n};
			while ( my ($key, $value) = each %type ) {
				next if ( $key !~/res|key|ts2avi/ );
				if ( $key eq $reserve[1] ) {
					$HTML .= qq {<option value="$key" selected>$value</option>\n};
				}
				else {
					$HTML .= qq {<option value="$key">$value</option>\n};
				}
			}
			$HTML .= qq {</select>\n};
			$HTML .= qq {チャンネル\n<select name="ch">\n};
			$ary_ref = $dbh->selectall_arrayref(
				"SELECT display, chtxt FROM ch INNER JOIN chdata ON ch.channel = chdata.ontv"
			);
			foreach my $ch ( @{$ary_ref} ) {
				if ( $ch->[1] eq $reserve[2] ) {
					$HTML .= qq {<option value="$ch->[1]" selected>$ch->[0]</option>\n};
				}
				else {
					$HTML .= qq {<option value="$ch->[1]">$ch->[0]</option>\n};
				}
			}
			$HTML .= qq {</select><br>\n};
			$HTML .= qq {タイトル\n<input type="text" name="title"     value="$reserve[3]" size=64><br>\n};
			$HTML .= qq {開始時刻\n<input type="text" name="begin"     value="$reserve[4]" maxlength=19 size=24>\n};
			$HTML .= qq {終了時刻\n<input type="text" name="end"       value="$reserve[5]" maxlength=19 size=24><br>\n};
			$HTML .= qq {隔日周期\n<input type="text" name="deltaday"  value="$reserve[6]" maxlength=2  size=2>\n};
			$HTML .= qq {時刻誤差\n<input type="text" name="deltatime" value="$reserve[7]" maxlength=2  size=2>\n};
			$HTML .= qq {オプション\n<input type="text" name="opt"     value="$reserve[8]">\n};
			$HTML .= qq {<input type="submit" name="update" value="更新">\n</form>\n};
			goto end;
		}
	}
	if ( $q->param( 'update' ) )
	{
		$type      = $q->param( 'type' );
		$chtxt     = $q->param( 'ch' );
		$title     = $q->param( 'title' );
		$begin     = $q->param( 'begin' );
		$end       = $q->param( 'end' );
		$deltaday  = $q->param( 'deltaday' );
		$deltatime = $q->param( 'deltatime' );
		$opt       = $q->param( 'opt' );
		$id        = $id[0];
		if ( $id[0] ) {
			$dbh->do( 
				"UPDATE rectime SET type = '$type', chtxt = '$chtxt', title = '$title', 
				btime = '$begin', etime = '$end', 
				deltaday = '$deltaday', deltatime = '$deltatime', opt = '$opt' 
				WHERE id = '$id'" 
			);
		}
		else {
			$dbh->do( 
				"INSERT INTO rectime ( type, chtxt, title, btime, etime, deltaday, deltatime, opt ) 
				VALUES ( '$type', '$chtxt', '$title', '$begin', '$end', '$deltaday', '$deltatime', '$opt' )" 
		);
		}
		$HTML .= qq {<a href="rectool.pl">トップ</a>\n<br>\n};
		$HTML .= qq {<a href="rectool.pl?mode=schedule">予約確認画面</a><br>\n};
		$HTML .= "更新しました。<br>\n5秒後に予約確認画面に移動します。<br>\n";
		$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="5; url=rectool.pl?mode=schedule">|;
		goto end;
	}
}

if ( $mode eq 'confirm' ) {
	# && $display && $start && $stop

	$HTML =~ s/%HTML_TITLE_OPT%/ - Reserver/;
	$HTML .= qq {<div style="float:left;">\n};
	&parse_program();
	if ( &check_error() )
	{
		# エラー
	}
	else {
		$desc = $dbh->selectrow_array(
			"SELECT exp FROM tv WHERE channel = '$channel' AND start = '$start' AND stop = '$stop' "
		);
		$HTML .= "録画予約の詳細設定を行ってください。<br>\n";
		$HTML .= "番組の詳細は次のとおりです。<br>\n";
		$HTML .= "番組名：$title<br>\n番組内容：$desc<br>\nチャンネル：$display<br>\n";
		$HTML .= qq {<form method="get" action="rectool.pl">\n};
		$HTML .= qq {<input type="hidden" name="mode"  value="reserve">\n};
		$HTML .= qq {<input type="hidden" name="ch"    value="$display">\n};
		$HTML .= qq {<input type="hidden" name="start" value="$start">\n};
		$HTML .= qq {<input type="hidden" name="stop"  value="$stop">\n};
		$HTML .= qq {<select name="opt">\n};
		$HTML .= qq {<option value="S">SD画質(720x480)</option>\n};
		$HTML .= qq {<option value="H">HD画質(1280x720)</option>\n};
		$HTML .= qq {<option value="Q">WQVGA画質(400x240)</option>\n};
		$HTML .= qq {<option value="F">FULLHD画質(1920x1080)</option>\n};
		$HTML .= qq {</select>\n};
		$check = $chtxt =~ /animax|atx|disney|kids/ ? 'checked' : '';
		$HTML .= qq {<input type="checkbox" name="opt" value="a" $check>アニメ\n};
		$check = $title =~ /\Q[二]\E/ ? 'checked' : '';
		$HTML .= qq {<input type="checkbox" name="opt" value="d" $check>二ヶ国語放送\n};
		$HTML .= qq {<input type="checkbox" name="opt" value="2">2passモード\n};
		$check = $title =~ /5\.1|5．1/ ? 'checked' : '';
		$HTML .= qq {<input type="checkbox" name="opt" value="5" $check>5.1ch放送\n};
		$HTML .= qq {<input type="checkbox" name="opt" value="x">Xvidモード\n};
		$HTML .= qq {<input type="submit" value="予約">\n</form>\n};
	}
	goto end;
}

if ( $mode eq 'reserve' ) {
	$HTML .= qq {<div style="float:left;">\n};
	&parse_program();
	@opt = $q->param( 'opt' );
	$opt = join '', @opt;
	if ( !&check_error ) {
		$dbh->do( 
			"INSERT INTO rectime ( type, chtxt, title, btime, etime, opt ) 
			VALUES ( 'res', '$chtxt', '$title', '$begin', '$end', '$opt' )" 
		);
	}
	$HTML .= qq {<a href="rectool.pl">トップ</a>\n<br>\n};
	$HTML .= qq {<a href="rectool.pl?mode=schedule">予約確認画面</a><br>\n};
	$HTML .= "録画予約を実行しました。<br>\n5秒後にトップへ移動します。<br>\n";
	$HTML =~ s|%REFRESH%|<meta http-equiv="refresh" content="5; url=rectool.pl">|;
	goto end;
}

if ( $mode eq 'program' ) {
	&draw_form();

	$HTML =~ s/%HTML_TITLE_OPT%/ - Program Viewer/;
	$unix = DateTime->now( time_zone => $tz )->strftime( '%Y%m%d%H%M%S' );
	$sql = 
		"SELECT tv.channel, 
			(SELECT display FROM ch WHERE ch.channel = tv.channel), 
		start, stop, title 
		FROM tv 
		INNER JOIN chdata ON tv.channel = chdata.ontv 
		WHERE $unix <= stop %CH% %DATE% %KEY% ORDER BY start";
#		INNER JOIN ch     ON tv.channel = ch.channel

	if ( $channel ) {
		my $ch = "AND tv.channel = '$channel'";
		$sql =~ s/%CH%/$ch/;
	}
	if ( $date_sel ) {
		$date_1 = $date_sel . '000000';
		$date_2 = Date::Simple->new( $date_sel =~ /(.{4})(.{2})(.{2})/ )->next->format('%Y%m%d') . '000000';
		my $date = "AND '$date_1' <= stop AND start <= '$date_2'";
		$sql =~ s/%DATE%/$date/;
	}
	if ( $key ) {
		my $key = "AND TITLE LIKE '%$key%'";
		$sql =~ s/%KEY%/$key/;
	}
	$sql =~ s/%CH%//;
	$sql =~ s/%DATE%//;
	$sql =~ s/%KEY%//;

	$ary_ref = $dbh->selectall_arrayref( $sql );
	foreach my $prg ( @{ $ary_ref } ) {
		my @date = $prg->[2] =~ /(.{4})(.{2})(.{2})(.{2})(.{2})(.{2})/;
		
		$date = $date[2];
		if ( $date != $prev ) {
			my $date = DateTime->new(
				year => $date[0], month  => $date[1], day    => $date[2], 
#				hour => $date[3], minute => $date[4], second => $date[5], 
				locale => 'ja_JP'
			);

			my $dn = $date->day_name;
			utf8::encode( $dn );
			$HTML .= qq {--------$date[1]/$date[2]($dn)--------<br>\n};
		}
		$prg->[1] = $q->url_encode( $prg->[1] );
		$HTML .= qq {$date[1]/$date[2] $date[3]:$date[4] };
		$HTML .= qq {<a href="rectool.pl?mode=confirm&amp;ch=$prg->[1]};
		$HTML .= qq {&amp;start=$prg->[2]&amp;stop=$prg->[3]">$prg->[4]</a><br>\n};
		$prev = $date;
	}

}

if ( $mode eq 'list' ) {
	require File::Find;
	my $recording = $cfg->param( 'path.recpath' );
	my $recorded  = $cfg->param( 'path.recorded' );
	@path = ( $recording, $recorded );

	File::Find::find( \&wanted, @path );

	@list = sort @list;
	foreach ( @list ) {
#		my ($tmp) = $_ =~ /無料≫(.*)/ if ( /無料≫/ );
		$HTML .= $_ . "$tmp<br>\n";
	}

	sub wanted {
		return if ( $File::Find::name =~ /Thumbs\.db/ );
		push @list, $File::Find::name;
	}
}

if ( $mode eq 'test' ) {
	require Data::Dumper;
	require Perl6::Slurp;

	$HTML .= 'Dumper<br>';
	$HTML .= DateTime->now( time_zone => $tz )->strftime( "%Y%m%d%H%M%S<br>\n" );
	$tmp = Perl6::Slurp::slurp( 'config.ini' );
	$tmp =~ s/\n/<br>\n/gs;
	$HTML .= $tmp;
	$ary_ref = $dbh->selectall_arrayref(
		"SELECT * from ch"
	);
	foreach my $prg ( @{ $ary_ref } ) {
		$HTML .= Data::Dumper->Dumper( $prg ) . "<br>\n";
	}
}

if ( !$mode ) {
	&draw_form();
	$HTML =~ s/%HTML_TITLE_OPT%/ - Top/;
	$HTML .= qq {Welcome to Rec10!<br>\n};
	$HTML .= qq {<a href="rectool.pl?mode=schedule">予約確認画面</a><br>\n};
#	$HTML .= qq {<a href="rectool.pl?mode=change&edit=edit">新規予約画面</a><br>\n};
	goto end;
}


end:
#<div style="float:right;">
$HTML .= <<EOM;
</div>
</body>
</html>
EOM

$HTML_HEADER = <<EOM;
<div align="center">
<script type="text/javascript"><!--
google_ad_client = "pub-6837289609486635";
/* 728x90, 作成済み 09/07/20 */
google_ad_slot = "6679390404";
google_ad_width = 728;
google_ad_height = 90;
//-->
</script>
<script type="text/javascript"
src="http://pagead2.googlesyndication.com/pagead/show_ads.js">
</script>
</div>
EOM

$HTML =~ s/%HTML_TITLE_OPT%//;
$HTML =~ s/%REFRESH%//;
$HTML =~ s/%SCRIPT%//;
$HTML =~ s/%HTML_HEADER%/$HTML_HEADER/;

print $HTTP_HEADER;
print $HTML;

sub draw_form {
	$channel = $dbh->selectrow_array("SELECT channel FROM ch WHERE display = '$display' ");

	# チャンネル指定
	$HTML .= qq {<form method="get" action="rectool.pl">\n};
	$HTML .= qq {<input type="hidden" name="mode" value="program">\n};
	$HTML .= qq {<select name="ch">\n<option value="" selected>無指定</option>\n};
	$ary_ref = $dbh->selectcol_arrayref(
		"SELECT display FROM ch INNER JOIN chdata ON ch.channel = chdata.ontv"
	);
	foreach my $ch ( @{$ary_ref} ) {
		if ( $ch eq $display ) {
			$HTML .= qq {<option value="$ch" selected>$ch</option>\n};
		}
		else {
			$HTML .= qq {<option value="$ch">$ch</option>\n};
		}
	}
	$HTML .= qq {</select>\n};

	# 日付指定
	$HTML .= qq {<select name="date">\n<option value="" selected>無指定</option>\n};
	$ary_ref = $dbh->selectcol_arrayref(
		"SELECT DISTINCT $SQL{'SUBSTR'} FROM tv"
	);
	$date_sel = $q->param( 'date' );
	foreach my $date ( @{ $ary_ref } ) {
		my @date = $date =~ /(.{4})(.{2})(.{2})/;
		$date_prt = "$date[1]/$date[2]";

		if ( $date eq $date_sel ) {
			$HTML .= qq {<option value="$date" selected>$date_prt</option>\n};
		}
		else {
			$HTML .= qq {<option value="$date">$date_prt</option>\n};
		}
	}
	$HTML .= qq {</select>\n};

	# キーワード指定
	$HTML .= qq {<input name="key" type="text" value="$key" style="width:200px;">\n};

	# フォーム描画
	$last_modified = localtime((stat 'rectool.pl')[9]);
	$HTML .= qq {<input type="submit" value="更新">\n</form>\n};
	$HTML .= qq {<span style="float:right; font-size: 6pt;">Last-Modified: $last_modified</span>\n};
	$HTML .= qq {<div style="float:left;">\n};
}

sub parse_program {
	@start   = $start =~ /(.{4})(.{2})(.{2})(.{2})(.{2})/;
	@stop    = $stop  =~ /(.{4})(.{2})(.{2})(.{2})(.{2})/;
	$channel = $dbh->selectrow_array("SELECT channel FROM ch  WHERE display = '$display'");
	$title   = $dbh->selectrow_array("SELECT title   FROM tv  WHERE channel = '$channel' AND start = '$start' AND stop = '$stop' ");
	$chtxt   = $dbh->selectrow_array("SELECT chtxt   FROM chdata WHERE ontv = '$channel'");
	$bctype  = $dbh->selectrow_array("SELECT bctype  FROM chdata WHERE ontv = '$channel'");
	if ( $bctype =~ /.s/ ) {
		$bctype = '_s%';
	}
	elsif ( $bctype =~ /te/ ) {
		$bctype = 'te%';
	}
	$title =~ s/\(/-/g;
	$title =~ s/\)//g;
	$begin = sprintf( '%04d-%02d-%02d %02d:%02d:%02d', @start, '00' );
	$end   = sprintf( '%04d-%02d-%02d %02d:%02d:%02d', @stop , '00' );
}

sub check_error {
	my $is_error = 1;

	if ( $dbh->selectrow_array( 
		"SELECT COUNT(*) FROM rectime 
		WHERE type = 'res' AND chtxt = '$chtxt' AND title = '$title' AND btime = '$begin' AND etime = '$end'" 
	) ) {
		$HTML .= "同一の番組が既に存在します。<br>\n";
	}
	elsif ( ( scalar $dbh->selectrow_array( 
		"SELECT COUNT(*) FROM rectime 
		INNER JOIN chdata ON rectime.chtxt = chdata.chtxt 
		WHERE chdata.bctype LIKE '$bctype' AND 
		( 
			NOT 
			( 
				( etime <= '$begin' ) 
					OR 
				( btime >= '$end'   ) 
			 ) 
		)
		AND type IN ( 'rec', 'res', 'key', 'keyevery' ) " 
	) ) >= 2 ) {
		$HTML .= "時間が被る番組が既に2個存在します。<br>\n";
	}
	else {
		$is_error = 0;
	}
	return $is_error;
}

